require 'g_level'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("parallax_background", "data/images/taivastausta-parallax_2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

--load tileset
--load tileset
lua_init_texture("tileset", "data/images/lvl_forest/forest_tileset.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("tileset2", "data/images/lvl_forest/forest_tileset2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
--lua_init_texture("fire", "data/images/particle.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("myParticle", "data/images/myParticle.png", h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("mattaat", "data/images/lvl_forest/forest_middle.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("fog", "data/images/lvl_forest/fog.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("wall", "data/images/lvl_forest/wall.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("switch", "data/images/lvl_forest/switch.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("sign", "data/images/lvl_forest/sign.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("sign2", "data/images/lvl_forest/sign2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

lua_init_texture("trees_1", "data/images/lvl_forest/puu_01.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_2", "data/images/lvl_forest/puu_02.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_3", "data/images/lvl_forest/puu_03.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_4", "data/images/lvl_forest/puu_04.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_5", "data/images/lvl_forest/puu_05.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_6", "data/images/lvl_forest/puu_06.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_7", "data/images/lvl_forest/puu_07.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_8", "data/images/lvl_forest/puunrunko.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

lua_init_texture("road_1", "data/images/lvl_forest/uudettiet/uusimetsatie1.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("road_2", "data/images/lvl_forest/uudettiet/uusimetsatie2.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("road_3", "data/images/lvl_forest/uudettiet/uusimetsatie3.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("reuna_test", "data/images/lvl_forest/reuna1.png", h, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua_init_texture("reuna1", "data/images/lvl_forest/reuna.png", h, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua_init_texture("reuna2", "data/images/lvl_forest/reuna2.png", h, WM_CLAMP, WM_CLAMP, AM_MODULATE)

-- props
lua_init_texture("rock_1", "data/images/lvl_forest/muut/kivi.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("rock_2", "data/images/lvl_forest/muut/kivi2.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("grass_1", "data/images/lvl_forest/grass_cartoon.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("grass_2", "data/images/lvl_forest/grass_cartoon2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("spikes", "data/images/lvl_forest/spikes.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- background
lua_init_texture("bg_1", "data/images/lvl_forest/metsatausta.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("bg_2", "data/images/lvl_forest/metsatausta2.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- foreground
lua_init_texture("fg_1", "data/images/lvl_forest/foreground_1.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("fg_2", "data/images/lvl_forest/foreground_2.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("fg_3", "data/images/lvl_forest/muut/foreground1.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.25,0.25,BM_DEFAULT) -- 1
lua:create_layer(0.5,0.5,BM_DEFAULT) -- 2
lua:create_layer(0.75,0.75,BM_DEFAULT) -- 3
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 4 --physics
lua:create_layer(1.1,1.1,BM_DEFAULT) -- 5
lua:create_layer(1.25,1.25,BM_DEFAULT) -- 6
lua:create_layer(1.0, 1.0, BM_ADDITIVE) -- 7 emitters
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 8 --dummy this is for exit menu purposes


-- Background starts
local background_size = 0.20
local scale = 0.4
lua:create_sprite("background", ST_TEXTURED,"parallax_background",      0.0, 0.0) 
lua:sprite_shape("background",ST_TEXTURED,                              scale *4096.0/2, scale * 2048.0/2)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,               0.0, 0.0, 1.0, 1.0)
g_level.upload("background",                                            0)

-- background mountains
local bgMountainsLenght = 7.5
lua:create_sprite("background-mountains", ST_TEXTURED,"bg_1",1000.0, 80.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("background-mountains", 0.5, 0.5, 0.5 , 1.0)
lua:sprite_shape("background-mountains",ST_TEXTURED, background_size*4096.0*bgMountainsLenght, background_size*1024.0*1.5)
lua:textured_sprite_tex_coords("background-mountains", ST_TEXTURED, 0.0, -0.5, bgMountainsLenght, 1.0)
g_level.upload("background-mountains", 1)

-- background forest
local bgForestLenght = 8.5
lua:create_sprite("background-forest", ST_TEXTURED,"bg_2", 2500.0, -150.0) 
lua:sprite_color("background-forest", 0.5, 0.5, 0.5 , 1.0)
lua:sprite_shape("background-forest", ST_TEXTURED, 4096*bgForestLenght/4, 1024*1.5/4)
lua:textured_sprite_tex_coords("background-forest", ST_TEXTURED, -bgForestLenght, -0.5, 0.0, 1.0)
g_level.upload("background-forest", 2)

-- lhipuut
for i=1, 20, 1
do
lua:create_sprite("bgtree", ST_TEXTURED,"trees_4",              i*1000-50.0, 70.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_3",              i*1000+200.0, 80.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_2",              i*1000+500.0, 50.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)
end
lua:create_sprite("bgtree", ST_TEXTURED,"trees_1",              200.0, 90.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_5",             -200.0, 130.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_5",              600.0, 90.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_7",              1800.0, 90.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_1",              10700.0, 90.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_7",              14800.0, 90.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)



-- background moor
for i=0, 8, 1
do
lua:create_sprite("bgtree", ST_TEXTURED,"mattaat",              i*2048, -50.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          1024, 256.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)
end
-- Background ends

-- foreground 2 starts
for i=0, 20, 1
do
lua:create_sprite("foreground-1", ST_TEXTURED, "fg_1", i*2000, -270.0)
lua:sprite_shape("foreground-1", ST_TEXTURED, 2*512.0, 2.5*64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("foreground-1", 6)

lua:create_sprite("foreground-1", ST_TEXTURED,"fg_2",i*2000+1000, -270.0)
lua:sprite_shape("foreground-1",ST_TEXTURED, 2*1024.0, 2.5*64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 2.0, 1.0)
g_level.upload("foreground-1", 6)
end

-- Foreground 2 ends

-- Roads start

-- tasainen maa
tmp_x = -512.0
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = -512.0+1024
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = -512.0+2048
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x =-512.0+2048+512+128
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.75, 0.5, 1.0, 0.75)
g_level.upload("ylamaki",                                       4)


-- tasainen maa
tmp_x = 2600
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         256.0+256.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.5, 1.0, 0.75)
g_level.upload("ylamaki",                                       4)

--piitk tasainen maa
local posX = 5000;

tmp_x = posX-1024+128
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         256.0+128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.5, 0.75, 0.75)
g_level.upload("ylamaki",                                       4)
tmp_x = posX
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+1024
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+2048
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+2048+512+128
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.75, 0.5, 1.0, 0.75)
g_level.upload("ylamaki",                                       4)

-- tasainen maa
tmp_x = 9000-512-127
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         256.0+128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.5, 0.75, 0.75)
g_level.upload("ylamaki",                                       4)
tmp_x = 9000+1
tmp_y = -128
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         256.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 0.5, 1.0)
g_level.upload("ylamaki",                                       4)
--ylamaki
tmp_x = 9000+512+256
tmp_y = 0.0
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 1.0, 0.5)
g_level.upload("ylamaki",                                       4)

-- tasainen maa
posX = 11600
posY = -128.0
tmp_x = posX-1024+256+128
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.5, 0.25, 0.75)
g_level.upload("ylamaki",                                       4)
tmp_x = posX
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+128+512
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.75, 0.5, 1.0, 0.75)
g_level.upload("ylamaki",                                       4)

-- tasainen maa
posX = 13600
posY = -128.0
tmp_x = posX-1024+128
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         256.0+128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.5, 0.75, 0.75)
g_level.upload("ylamaki",                                       4)
tmp_x = posX
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+1024
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+1024+128+512
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.75, 0.5, 1.0, 0.75)
g_level.upload("ylamaki",                                       4)

-- tasainen maa
posX = 18400
posY = -128.0
tmp_x = posX-1024+128
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         256.0+128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.5, 0.75, 0.75)
g_level.upload("ylamaki",                                       4)
tmp_x = posX
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+1024
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+2048
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         512.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.75, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
tmp_x = posX+2048+128+512
tmp_y = posY
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 128.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.75, 0.5, 1.0, 0.75)
g_level.upload("ylamaki",                                       4)

-- pieni maa
tmp_x = 3200
tmp_y = -200
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 0.25, 0.5)
g_level.upload("ylamaki",                                       4)
-- pieni maa
tmp_x = 3600
tmp_y = -260
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 0.25, 0.5)
g_level.upload("ylamaki",                                       4)

-- pieni maa
tmp_x = 15560
tmp_y = -220
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 0.25, 0.5)
g_level.upload("ylamaki",                                       4)
-- pieni maa
tmp_x = 15930
tmp_y = -90
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 0.25, 0.5)
g_level.upload("ylamaki",                                       4)
-- pieni maa
tmp_x = 16430
tmp_y = -70
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 0.25, 0.5)
g_level.upload("ylamaki",                                       4)
-- pieni maa
tmp_x = 16920
tmp_y = -230
lua:create_sprite("ylamaki", ST_TEXTURED,"tileset2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         128.0, 256.0)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 0.25, 0.5)
g_level.upload("ylamaki",                                       4)

-- kyltti
tmp_x = 20600
tmp_y = -60.0
lua:create_sprite("ylamaki", ST_TEXTURED,"sign2",             tmp_x, tmp_y) 
lua:sprite_shape("ylamaki",ST_TEXTURED,                         64, 64)
lua:textured_sprite_tex_coords("ylamaki", ST_TEXTURED,          0.0, 0.0, 1.0, 1.0)
g_level.upload("ylamaki",                                       4)
--Roads end



--segments
--first road
lua:create_segment(-698.986, -85.8447)
lua:add_segment(-396.986, -145.845)
lua:add_segment(-171.986, -143.845)
lua:add_segment(65.0137, -99.8447)
lua:add_segment(187.014, -67.8447)
lua:add_segment(321.014, -88.8447)
lua:add_segment(492.014, -124.845)
lua:add_segment(637.189, -153.965)
lua:add_segment(885.189, -145.965)
lua:add_segment(1105.19, -99.9651)
lua:add_segment(1263.19, -67.9651)
lua:add_segment(1514.19, -123.965)
lua:add_segment(1666.52, -149.271)
lua:add_segment(1896.52, -138.271)
lua:add_segment(2049.52, -119.271)
lua:add_segment(2060.52, -131.271)
lua:upload_segmentstrip()

lua:create_segment(2327.1, -137.557)
lua:add_segment(2335.1, -126.557)
lua:add_segment(2430.1, -163.557)
lua:add_segment(2558.1, -184.557)
lua:add_segment(2648.1, -178.557)
lua:add_segment(2844.1, -121.557)
lua:add_segment(2867.1, -121.557)
lua:add_segment(2870.1, -130.557)
lua:upload_segmentstrip()

lua:create_segment(3963.54, -129.557)
lua:add_segment(3978.54, -126.557)
lua:add_segment(4066.54, -164.557)
lua:add_segment(4179.54, -188.557)
lua:add_segment(4313.54, -172.557)
lua:add_segment(4475.54, -124.557)
lua:add_segment(4619.54, -79.5571)
lua:add_segment(4756.54, -79.5571)
lua:add_segment(4931.54, -119.557)
lua:add_segment(5119.39, -154.557)
lua:add_segment(5476.39, -129.557)
lua:add_segment(5575.39, -105.557)
lua:add_segment(5698.26, -63.5571)
lua:add_segment(6118.61, -148.557)
lua:add_segment(6225.61, -154.557)
lua:add_segment(6528.59, -126.557)
lua:add_segment(6631.6, -90.5571)
lua:add_segment(6776.78, -70.5571)
lua:add_segment(6964.08, -113.557)
lua:add_segment(7224.67, -153.557)
lua:add_segment(7565.21, -124.557)
lua:add_segment(7574.21, -132.557)
lua:upload_segmentstrip()

lua:create_segment(8218.5, -135.557)
lua:add_segment(8229.5, -130.557)
lua:add_segment(8343.5, -171.557)
lua:add_segment(8456.5, -185.557)
lua:add_segment(8635.5, -155.557)
lua:add_segment(8804.5, -106.557)
lua:add_segment(8895.5, -72.5571)
lua:add_segment(9026.5, -76.5571)
lua:add_segment(9191.5, -120.557)
lua:add_segment(9320.02, -102.557)
lua:add_segment(9490.02, -48.5571)
lua:add_segment(9708.18, 27.4429)
lua:add_segment(10022.2, 134.443)
lua:add_segment(10036.2, 132.443)
lua:upload_segmentstrip()

lua:create_segment(11070.5, -132.297)
lua:add_segment(11078.5, -125.297)
lua:add_segment(11118.5, -121.297)
lua:add_segment(11246.5, -73.2971)
lua:add_segment(11359.5, -76.2971)
lua:add_segment(11693.5, -154.297)
lua:add_segment(12049.3, -128.297)
lua:add_segment(12115.3, -124.297)
lua:add_segment(12123.3, -132.297)
lua:upload_segmentstrip()

lua:create_segment(12558.5, -133.297)
lua:add_segment(12567.5, -127.297)
lua:add_segment(12679.5, -171.297)
lua:add_segment(12870.5, -189.297)
lua:add_segment(13085.5, -132.297)
lua:add_segment(13210.5, -80.2971)
lua:add_segment(13349.5, -68.2971)
lua:add_segment(13576.8, -127.297)
lua:add_segment(13892.3, -145.297)
lua:add_segment(14116.5, -124.297)
lua:add_segment(14255.7, -76.2971)
lua:add_segment(14387.6, -80.2971)
lua:add_segment(14642.7, -128.297)
lua:add_segment(14882.3, -150.297)
lua:add_segment(15131.4, -126.297)
lua:add_segment(15146.4, -130.297)
lua:upload_segmentstrip()

lua:create_segment(17356.9, -140.453)
lua:add_segment(17363.9, -135.452)
lua:add_segment(17504.9, -183.452)
lua:add_segment(17780.9, -170.452)
lua:add_segment(17988.9, -86.4525)
lua:add_segment(18172.9, -80.4525)
lua:add_segment(18438.6, -132.452)
lua:add_segment(18748.2, -143.452)
lua:add_segment(18926.7, -122.452)
lua:add_segment(19021.7, -83.4525)
lua:add_segment(19169, -75.4525)
lua:add_segment(19457.2, -129.452)
lua:add_segment(19813.7, -141.452)
lua:add_segment(20080.1, -83.4525)
lua:add_segment(20242.7, -86.4525)
lua:add_segment(20624.5, -156.453)
lua:add_segment(20789.5, -145.452)
lua:upload_segmentstrip()

lua:create_segment(3142.66, -78.8974)
lua:add_segment(3147.66, -68.8974)
lua:add_segment(3247.66, -69.8974)
lua:add_segment(3254.66, -78.8974)
lua:upload_segmentstrip()


lua:create_segment(3543.65, -141.577)
lua:add_segment(3548.65, -131.577)
lua:add_segment(3649.65, -130.577)
lua:add_segment(3655.65, -138.577)
lua:upload_segmentstrip()




--APUVIIVA
--lua:create_segment(0, -320)
--lua:add_segment(33047, -320)
--lua:upload_segmentstrip()
--pieni maa
local small_piece_x = 15500
local small_piece_y = -100
local diff_x = 6571
local diff_y = 31
lua:create_segment(small_piece_x, small_piece_y)
lua:add_segment(small_piece_x+(6581-diff_x), small_piece_y+(-20+diff_y))
lua:add_segment(small_piece_x+(6677-diff_x), small_piece_y+(-24+diff_y))
lua:add_segment(small_piece_x+(6683-diff_x), small_piece_y+(-34+diff_y))
lua:upload_segmentstrip()

--pieni maa
local diff_x = 6671
local diff_y = 0
lua:create_segment(small_piece_x+(7042-diff_x), small_piece_y+(134+diff_y))
lua:add_segment(small_piece_x+(7051-diff_x), small_piece_y+(141+diff_y))
lua:add_segment(small_piece_x+(7150-diff_x), small_piece_y+(139+diff_y))
lua:add_segment(small_piece_x+(7157-diff_x), small_piece_y+(129+diff_y))
lua:upload_segmentstrip()

--pieni maa
local diff_x = 6771
local diff_y = -30
lua:create_segment(small_piece_x+(7640-diff_x), small_piece_y+(185+diff_y))
lua:add_segment(small_piece_x+(7651-diff_x), small_piece_y+(194+diff_y))
lua:add_segment(small_piece_x+(7751-diff_x), small_piece_y+(188+diff_y))
lua:add_segment(small_piece_x+(7757-diff_x), small_piece_y+(175+diff_y))
lua:upload_segmentstrip()

--pieni maa
local diff_x = 6871
local diff_y = -31
lua:create_segment(small_piece_x+(8231-diff_x), small_piece_y+(25+diff_y))
lua:add_segment(small_piece_x+(8242-diff_x), small_piece_y+(33+diff_y))
lua:add_segment(small_piece_x+(8349-diff_x), small_piece_y+(28+diff_y))
lua:add_segment(small_piece_x+(8355-diff_x), small_piece_y+(18+diff_y))
lua:upload_segmentstrip()

--SEGMENTS end

--STOPPERS
stopper(LEFT,-700.0) --direction,place
stopper(RIGHT,21000.0) --direction,place (slihtly unnecessary)

--UNSTABLES
lua:do_file("data/scripts/inc_tutorial_unstables.lua")
create_wooden_unstable(7892, -114) --x,y
create_wooden_unstable(10285, 123) --x,y
create_wooden_unstable(10587, 36) --x,y
create_wooden_unstable(10873, -44) --x,y

--TRIGGERS
--finished
--trigger("data/scripts/srt_level_finished.lua","",40,1000,3500,123) --script, width, height, x, y
trigger("data/scripts/srt_level_finished.lua","",40,1000,20820,123) --script, width, height, x, y
--secure kill
trigger("data/scripts/srt_game_over.lua","",30000,100,10820,-450) --script, width, height, x, y

--LEVER
lua:do_file("data/scripts/inc_tutorial_lever.lua") --adds the lever combination into this map

--SHOOTERS
lua:do_file("data/scripts/inc_emitter_bullet.lua")
local bullet_speed = 0.33
--first bullet
local path_list = {}
table.insert(path_list,{12339.0,-200.0,0.0}) --x,y, time
table.insert(path_list,{12339.0,400.0,1.0}) --x,y, time
create_emitter_bullet(path_list, true, bullet_speed, 7)--path_list, is_repeating,speed ,layer
--second bullet
local path_list = {}
table.insert(path_list,{15300.0,-200.0,0.0}) --x,y, time
table.insert(path_list,{15300.0,400.0,1.0}) --x,y, time
create_emitter_bullet(path_list, true, bullet_speed+0.05, 7)--path_list, is_repeating,speed ,layer
--third bullet
local path_list = {}
table.insert(path_list,{15700.0,-200.0,0.0}) --x,y, time
table.insert(path_list,{15700.0,400.0,1.0}) --x,y, time
create_emitter_bullet(path_list, true, bullet_speed-0.05, 7)--path_list, is_repeating,speed ,layer
--fourth bullet
local path_list = {}
table.insert(path_list,{16200.0,-200.0,0.0}) --x,y, time
table.insert(path_list,{16200.0,400.0,1.0}) --x,y, time
create_emitter_bullet(path_list, true, bullet_speed, 7)--path_list, is_repeating,speed ,layer
--fifth bullet
local path_list = {}
table.insert(path_list,{16700.0,-200.0,0.0}) --x,y, time
table.insert(path_list,{16700.0,400.0,1.0}) --x,y, time
create_emitter_bullet(path_list, true, bullet_speed+0.075, 7)--path_list, is_repeating,speed ,layer
--sixth bullet
local path_list = {}
table.insert(path_list,{17200.0,-200.0,0.0}) --x,y, time
table.insert(path_list,{17200.0,400.0,1.0}) --x,y, time
create_emitter_bullet(path_list, true, bullet_speed-0.075, 7)--path_list, is_repeating,speed ,layer

--PENDULUM
--lua:do_file("data/scripts/inc_tutorial_hammer.lua")
--local idle_times = {5.0,1.0}
--create_hammer(idle_times, 5700.0, 0.0, 0.0,300.0,4) --from_x, from_y, to_x, to_y, layer
--local idle_times = {3.0,1.0,1.0}
--create_hammer(idle_times, 6000.0, 0.0, 0.0,300.0,4) --from_x, from_y, to_x, to_y, layer
--local idle_times = {4.0,4.0}
--create_hammer(idle_times, 6300.0, 0.0, 0.0,300.0,4) --from_x, from_y, to_x, to_y, layer

--PIG
--lua:do_file("data/scripts/inc_burning_pig.lua")
--create_burning_pig(18500.0,19500.0,4)

--BATS
lua:do_file("data/scripts/inc_bats.lua")
--create bat path
local path = {}
table.insert(path,{5449, 184})
table.insert(path,{5696, 103})
table.insert(path,{5828, 139})
table.insert(path,{5989, 86})
table.insert(path,{6150, 139})
table.insert(path,{6329, 89})
table.insert(path,{6543, 231})
create_moving_bat(path, false,4)
local path = {}
table.insert(path,{18449, 214})
table.insert(path,{18707, 73})
table.insert(path,{18984, 117})
table.insert(path,{19251, 35})
table.insert(path,{19517, 187})
create_moving_bat(path, false,4)
--create still bat
create_still_bat(2880,20,false,4)
create_still_bat(3580,30,false,4)
create_still_bat(8010,70,false,4)
create_still_bat(15370,110,false,4)
create_still_bat(15700,210,false,4)


--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player_trigger.lua",0)
lua:init_camera_binder(-700.0, 20800.0, -400.0, 1500.0) -- left, right, bottom, up
lua:upload_player_to_layer(4)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, 0.0, 200.0) -- set the player to it's right position
--Player end

--INIT POINT SETTINGS
lua:points_reset(160, 7) --par_time (the time to be aimed for, in seconds), max_combo (maximum amount of bats in the map)
lua:add_point_level("poor",100) -- description of success, points
lua:add_point_level("average",120)
lua:add_point_level("good",150)
lua:add_point_level("perfect",170)
lua:add_point_level("insane",200)
lua:timer_start() --starts the timer for the level HOX: HAS TO BE LAST!!!

lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands
g_level.next_level = "data/scripts/lvl_bar.lua"

fade_in(3)
